
#include "renderer.h"
#include "manager.h"
#include "modeGame.h"
#include "modeTitle.h"
#include "modelManager.h"
#include "texManager.h"
#include "sceneModel.h"
#include "light.h"
#include "debugStr.h"

// -------- -------- -------- -------- -------- -------- -------- --------
// 
// -------- -------- -------- -------- -------- -------- -------- --------
void CSceneModel::Init(void)
{
	SetPos(D3DXVECTOR3(0.f, 0.f, 0.f));		// W
	SetRot(D3DXVECTOR3(0.f, 0.f, 0.f));		// ]
	SetScl(D3DXVECTOR3(1.f, 1.f, 1.f));		// g嗦
}

// -------- -------- -------- -------- -------- -------- -------- --------
// I
// -------- -------- -------- -------- -------- -------- -------- --------
void CSceneModel::Uninit(void)
{

}

// -------- -------- -------- -------- -------- -------- -------- --------
// XV
// -------- -------- -------- -------- -------- -------- -------- --------
void CSceneModel::Update(void)
{

}

// -------- -------- -------- -------- -------- -------- -------- --------
// `
// -------- -------- -------- -------- -------- -------- -------- --------
void CSceneModel::Draw(void)
{
	// foCX̎擾
	LPDIRECT3DDEVICE9 pDevice = CRenderer::GetDevice();

	D3DXMatrixIdentity(&m_mtxWorld);// sPʍsɂ( g嗦1,0ŏ )
	D3DXMatrixIdentity(&m_mtxScl);	// sPʍsɂ( g嗦1,0ŏ )
	D3DXMatrixIdentity(&m_mtxRot);	// sPʍsɂ( g嗦1,0ŏ )
	D3DXMatrixIdentity(&m_mtxPos);	// sPʍsɂ( g嗦1,0ŏ )
	
	// [hϊsݒ肵ĕϊ
	D3DXMatrixScaling(&m_mtxScl, m_scl.x, m_scl.y, m_scl.z);	// gs
	m_mtxRot = GetMatrixRot(this);
	m_mtxPos = GetMatrixPos(this);

	D3DXMatrixMultiply(&m_mtxWorld, &m_mtxWorld, &m_mtxScl);
	D3DXMatrixMultiply(&m_mtxWorld, &m_mtxWorld, &m_mtxRot);
	D3DXMatrixMultiply(&m_mtxWorld, &m_mtxWorld, &m_mtxPos);

	// foCXɃ[hϊsݒ
	pDevice->SetTransform(D3DTS_WORLD, &m_mtxWorld);

	// ݃foCXɐݒ肳Ă}eA̎擾
	D3DXMATERIAL* pMat = CManager::GetModelManager()->GetModelMat(m_strFilePass);
	D3DMATERIAL9 matDef;
	pDevice->GetMaterial(&matDef);
	// f̃}eAƂɐݒ
	for(int nCntMat = 0; nCntMat < (int)CManager::GetModelManager()->GetModelNumMat(m_strFilePass); nCntMat++)
	{
		// foCXɃ}eAݒ
		pDevice->SetMaterial(&pMat->MatD3D);

		// eNX`̐ݒ
		if(pMat[nCntMat].pTextureFilename != nullptr)
		{
			pDevice->SetTexture(0, CManager::GetTexManager()->GetTexInterface(pMat[nCntMat].pTextureFilename));
		}
		else
		{// eNX`Ȃnull
			pDevice->SetTexture(0, nullptr);
		}

		// `
		CManager::GetModelManager()->GetModelMesh(m_strFilePass)->DrawSubset(nCntMat);

		pDevice->SetMaterial(&matDef);	// ɖ߂
	}
}

// ======== ======== ======== ======== ======== ======== ======== ========
// ]s
// -------- -------- -------- -------- -------- -------- -------- --------
D3DXMATRIX CSceneModel::GetMatrixRot(CSceneModel *pParts)
{
	D3DXMATRIX mtxrot;
	D3DXMatrixIdentity(&mtxrot);	// Pʍs
	if (pParts->m_pParent == nullptr)
	{
		D3DXMatrixRotationYawPitchRoll(&mtxrot, m_rot.y, m_rot.x, m_rot.z);
		return mtxrot;
	}

	D3DXMatrixRotationYawPitchRoll(&mtxrot, pParts->m_baseRot.y, pParts->m_baseRot.x, pParts->m_baseRot.z);
	return mtxrot * GetMatrixRot(pParts->m_pParent);
}

// ======== ======== ======== ======== ======== ======== ======== ========
// ss
// -------- -------- -------- -------- -------- -------- -------- --------
D3DXMATRIX CSceneModel::GetMatrixPos(CSceneModel *pParts)
{
	D3DXMATRIX mtxpos;
	D3DXMatrixIdentity(&mtxpos);	// Pʍs
	if (pParts->m_pParent == nullptr)
	{
		D3DXMatrixTranslation(&mtxpos, m_basePos.x + m_pos.x, m_basePos.y + m_pos.y, m_basePos.z + m_pos.z);
		return mtxpos;
	}

	D3DXMatrixTranslation(&mtxpos, pParts->m_basePos.x, pParts->m_basePos.y, pParts->m_basePos.z);
	return mtxpos * GetMatrixWorld(pParts->m_pParent);
}

// ======== ======== ======== ======== ======== ======== ======== ========
// [hs
// -------- -------- -------- -------- -------- -------- -------- --------
D3DXMATRIX CSceneModel::GetMatrixWorld(CSceneModel *pParts)
{
	D3DXMATRIX mtxWorld, mtxScl, mtxRot, mtxPos;

	D3DXMatrixIdentity(&mtxWorld);	// sPʍsɂ( g嗦1,0ŏ )
	D3DXMatrixIdentity(&mtxScl);	// sPʍsɂ( g嗦1,0ŏ )
	D3DXMatrixIdentity(&mtxRot);	// sPʍsɂ( g嗦1,0ŏ )
	D3DXMatrixIdentity(&mtxPos);	// sPʍsɂ( g嗦1,0ŏ )

	// [hϊsݒ肵ĕϊ
	D3DXVECTOR3 scl = pParts->GetScl();
	D3DXVECTOR3 rot = pParts->GetRot();
	D3DXVECTOR3 pos = pParts->GetPos();
	D3DXMatrixScaling(&mtxScl, scl.x, scl.y, scl.z);	// gs
	D3DXMatrixRotationYawPitchRoll(&mtxRot, rot.y, rot.x, rot.z);
	D3DXMatrixTranslation(&mtxPos, pos.x, pos.y, pos.z);

	D3DXMatrixMultiply(&mtxWorld, &mtxWorld, &mtxScl);
	D3DXMatrixMultiply(&mtxWorld, &mtxWorld, &mtxRot);
	D3DXMatrixMultiply(&mtxWorld, &mtxWorld, &mtxPos);

	if (pParts->m_pParent == nullptr)
	{
		return mtxWorld;
	}
	return mtxWorld * GetMatrixWorld(pParts->m_pParent);
}

// -------- -------- -------- -------- -------- -------- -------- --------
// 쐬
// -------- -------- -------- -------- -------- -------- -------- --------
CSceneModel *CSceneModel::Create(const D3DXVECTOR3 &pos, const D3DXVECTOR3 &rot, const D3DXVECTOR3 &scl, const std::string &strFilePass)
{
	// CScene3D̐
	CSceneModel *pSceneModel;
	pSceneModel = new CSceneModel();
	pSceneModel->Init();

	pSceneModel->SetPos(pos);
	pSceneModel->SetRot(rot);
	pSceneModel->SetBasePos(pos);
	pSceneModel->SetBaseRot(rot);
	pSceneModel->SetScl(scl);
	pSceneModel->m_strFilePass = strFilePass;
	pSceneModel->m_strPartsName = strFilePass;

	// f̐
	pSceneModel->CreateModel(pSceneModel->m_strFilePass);

	return pSceneModel;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// Partsw
// -------- -------- -------- -------- -------- -------- -------- --------
CSceneModel *CSceneModel::Create(const D3DXVECTOR3 &pos, const D3DXVECTOR3 &rot, const D3DXVECTOR3 &scl, const std::string &strFilePass, std::string strPartsName)
{
	// CScene3D̐
	CSceneModel *pSceneModel;
	pSceneModel = new CSceneModel();
	pSceneModel->Init();

	pSceneModel->SetPos(pos);
	pSceneModel->SetRot(rot);
	pSceneModel->SetBasePos(pos);
	pSceneModel->SetBaseRot(rot);
	pSceneModel->SetScl(scl);
	pSceneModel->m_strFilePass = strFilePass;
	pSceneModel->m_strPartsName = strPartsName;

	// f̐
	pSceneModel->CreateModel(pSceneModel->m_strFilePass);

	return pSceneModel;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// f
// -------- -------- -------- -------- -------- -------- -------- --------
void CSceneModel::CreateModel(std::string strFilePass)
{
	// f}l[Wɐ
	CModelManager *modelManager = CManager::GetModelManager();
	if (modelManager->SetModel(strFilePass))
	{
		// eNX`̃Zbg
		D3DXMATERIAL* pMat = CManager::GetModelManager()->GetModelMat(strFilePass);
		for (int nCntMat = 0; nCntMat < (int)CManager::GetModelManager()->GetModelNumMat(strFilePass); nCntMat++)
		{
			// gpĂeNX`Γǂݍ
			if (pMat[nCntMat].pTextureFilename != nullptr && lstrlen(pMat[nCntMat].pTextureFilename) > 0)
			{
				CManager::GetTexManager()->SetTex(pMat[nCntMat].pTextureFilename);
			}
			else { pMat[nCntMat].pTextureFilename = nullptr; }
		}
		//---------------------------------------------
		// f̒_̍őlAŏl̎擾
		//---------------------------------------------
		LPD3DXMESH pMesh = nullptr;
		pMesh = modelManager->GetModelMesh(strFilePass);
		D3DXVECTOR3 Vertex;
		D3DXVECTOR3 min = D3DXVECTOR3(0.f, 0.f, 0.f);
		D3DXVECTOR3 max = D3DXVECTOR3(0.f, 0.f, 0.f);

		//obt@bN
		BYTE *pVtx = nullptr;							// _obt@
		pMesh->LockVertexBuffer(D3DLOCK_READONLY, (void**)&pVtx);
		DWORD FVF = pMesh->GetFVF();					// _tH[}bg擾B
		DWORD VertexSize = D3DXGetFVFVertexSize(FVF);	// _̃TCY擾B

														// _̎擾
		for (int nCntMesh = 0; nCntMesh < static_cast<int>(pMesh->GetNumVertices()); nCntMesh++)
		{
			Vertex = *(D3DXVECTOR3*)pVtx;				// _W擾B
			min.x = RETURN_MIN(min.x, Vertex.x);		// Xŏl
			max.x = RETURN_MAX(max.x, Vertex.x);		// Xől
			min.y = RETURN_MIN(min.y, Vertex.y);		// Yŏl
			max.y = RETURN_MAX(max.y, Vertex.y);		// Yől
			min.z = RETURN_MIN(min.z, Vertex.z);		// Zŏl
			max.z = RETURN_MAX(max.z, Vertex.z);		// Zől
			pVtx += VertexSize;							// i߂
		}
		//obt@̃AbN
		pMesh->UnlockVertexBuffer();

		// ,,s̎擾
		SetSize(D3DXVECTOR3(max.x - min.x, max.y - min.y, max.z - min.z));
	}
}

// ======== ======== ======== ======== ======== ======== ======== ========
// Parts擾
// -------- -------- -------- -------- -------- -------- -------- --------
CSceneModel *CSceneModel::GetParts(std::string partsName)
{
	for (int n = 0; n < MAX_SCENE_PRIORITY; n++)
	{
		std::list<CScene*> *lisScene = CScene::GetScene(n);
		for (CScene* pScene : *lisScene)
		{
			if (pScene == nullptr)continue;
			// ^Cv̎擾
			CScene::CLASSTYPE type = pScene->GetClassType();

			if (type == CScene::CLASSTYPE::SCENE_MODEL)
			{
				// _ELXg
				CSceneModel *pModel = ((CSceneModel*)pScene);

				// vꂽp[cԋp
				if (pModel->GetPartsName() == partsName) { return pModel; }
			}
		}
	}

	// p[c͂܂ł
	return nullptr;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// eParts擾
// -------- -------- -------- -------- -------- -------- -------- --------
CSceneModel *CSceneModel::GetParent(CSceneModel *pParts)
{
	if (pParts == nullptr) { return nullptr; }
	return pParts->m_pParent;
}
